import { StarXpandCommand } from "star-io10-web";

export class ReceiptSample07_Lunch1_Template {
  static async createTemplate(): Promise<string> {
    let builder = new StarXpandCommand.StarXpandCommandBuilder();

    builder.addDocument(
      new StarXpandCommand.DocumentBuilder()
        .settingPrintableArea(48.0)
        .addPrinter(
          new StarXpandCommand.PrinterBuilder()
            .styleAlignment(StarXpandCommand.Printer.Alignment.Center)
            .styleCjkCharacterPriority([
              StarXpandCommand.Printer.CjkCharacterType.Japanese,
            ])
            .styleInternationalCharacter(
              StarXpandCommand.Printer.InternationalCharacterType.Japan,
            )
            .actionPrintImage(
              new StarXpandCommand.Printer.ImageParameter("logo_01.png", 400),
            )
            .actionFeedLine(1)
            .actionPrintText("[")
            .styleBold(true)
            .actionPrintText("領収書")
            .styleBold(false)
            .actionPrintText("]\n")
            .actionPrintText("${store_name}\n")
            .add(
              new StarXpandCommand.PrinterBuilder()
                .styleLineSpace(3.0)
                .actionPrintText("${address}"),
            )
            .actionPrintText(
              "\nTEL:${telephone_number}\n" +
                "登録番号:${registration_number}\n",
            )
            .styleAlignment(StarXpandCommand.Printer.Alignment.Left)
            .actionPrintText(
              "${datetime}\n" +
                "レジ:${register_number%04d}" +
                "    担当:${staff_number%04d}\n" +
                "人数:${number_of_people}名\n" +
                "伝票名:${voucher_name}\n" +
                "取引No:${transaction_number}\n",
            )
            .actionFeedLine(1)
            .actionPrintText("ご利用ありがとうございます\n")
            .actionFeedLine(1)
            .add(
              new StarXpandCommand.PrinterBuilder(
                new StarXpandCommand.Printer.PrinterParameter().setTemplateExtension(
                  new StarXpandCommand.TemplateExtensionParameter().setEnableArrayFieldData(
                    true,
                  ),
                ),
              )
                .actionPrintText(
                  "${item_list.name}\n",
                  new StarXpandCommand.Printer.TextParameter().setWidth(
                    16,
                    new StarXpandCommand.Printer.TextWidthParameter().setWidthType(
                      StarXpandCommand.Printer.TextWidthType.Full,
                    ),
                  ),
                )
                .actionPrintText(
                  "\\${item_list.unit_price}  ${item_list.number_of_items}点  \\${item_list.price}\n",
                  new StarXpandCommand.Printer.TextParameter().setWidth(
                    32,
                    new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                      StarXpandCommand.Printer.TextAlignment.Right,
                    ),
                  ),
                ),
            )
            .actionPrintText("－－－－－－－－－－－－－－－－\n")
            .actionPrintText("小計")
            .actionPrintText(
              "${total_number_of_items}点  \\${subtotal_price}\n",
              new StarXpandCommand.Printer.TextParameter().setWidth(
                28,
                new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                  StarXpandCommand.Printer.TextAlignment.Right,
                ),
              ),
            )
            .actionFeed(2.0)
            .actionPrintText("合計")
            .styleBold(true)
            .actionPrintText(
              "\\${total_price}\n",
              new StarXpandCommand.Printer.TextParameter().setWidth(
                28,
                new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                  StarXpandCommand.Printer.TextAlignment.Right,
                ),
              ),
            )
            .styleBold(false)
            .actionPrintText("(内消費税等")
            .actionPrintText(
              "\\${total_tax})\n",
              new StarXpandCommand.Printer.TextParameter().setWidth(
                21,
                new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                  StarXpandCommand.Printer.TextAlignment.Right,
                ),
              ),
            )
            .actionPrintText("(10%標準対象")
            .actionPrintText(
              "\\${tax_rate_10_target})\n",
              new StarXpandCommand.Printer.TextParameter().setWidth(
                20,
                new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                  StarXpandCommand.Printer.TextAlignment.Right,
                ),
              ),
            )
            .actionPrintText("( 内消費税等")
            .actionPrintText(
              "\\${tax_rate_10_tax})\n",
              new StarXpandCommand.Printer.TextParameter().setWidth(
                20,
                new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                  StarXpandCommand.Printer.TextAlignment.Right,
                ),
              ),
            )
            .actionPrintText("(")
            .actionPrintText(
              "${payment_method}",
              new StarXpandCommand.Printer.TextParameter().setWidth(
                10,
                new StarXpandCommand.Printer.TextWidthParameter().setWidthType(
                  StarXpandCommand.Printer.TextWidthType.Full,
                ),
              ),
            )
            .actionPrintText(
              "\\${payment_amount})\n",
              new StarXpandCommand.Printer.TextParameter().setWidth(
                11,
                new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                  StarXpandCommand.Printer.TextAlignment.Right,
                ),
              ),
            )
            .actionPrintText("お預かり")
            .actionPrintText(
              "\\${deposit_amount}\n",
              new StarXpandCommand.Printer.TextParameter().setWidth(
                24,
                new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                  StarXpandCommand.Printer.TextAlignment.Right,
                ),
              ),
            )
            .actionPrintText("お釣り")
            .styleBold(true)
            .actionPrintText(
              "\\${change_amount}\n",
              new StarXpandCommand.Printer.TextParameter().setWidth(
                26,
                new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                  StarXpandCommand.Printer.TextAlignment.Right,
                ),
              ),
            )
            .styleAlignment(StarXpandCommand.Printer.Alignment.Center)
            .styleBold(false)
            .actionFeed(2.0)
            .actionPrintText("上記正に領収いたしました\n")
            .actionFeedLine(1)
            .styleAlignment(StarXpandCommand.Printer.Alignment.Left)
            .actionPrintText("${note}\n")
            .actionCut(StarXpandCommand.Printer.CutType.Partial),
        ),
    );
    return await builder.getCommands();
  }

  static async getFieldData(): Promise<string> {
    return Promise.resolve(
      `{
    "store_name" : "Starカフェ 丸の内店",
    "address" : "東京都千代田区\\n○○１丁目２－３",
    "telephone_number" : "01-2345-6789",
    "registration_number" : "T1234567890123",
    "datetime" : "2022/01/01 12:34:56",
    "register_number" : 1,
    "staff_number" : 2,
    "number_of_people" : 1,
    "voucher_name" : "伝票00010001",
    "transaction_number" : "000120160510111212345",
    "item_list" : [
        {
            "name" : "ランチセットＡ",
            "unit_price" : 1100,
            "number_of_items" : 1,
            "price" : 1100
        },
        {
            "name" : "アイスコーヒー",
            "unit_price" : 400,
            "number_of_items" : 1,
            "price" : 400
        }
    ],
    "total_number_of_items" : 2,
    "subtotal_price" : 1500,
    "total_price" : 1500,
    "total_tax" : 136,
    "tax_rate_10_target" : 1500,
    "tax_rate_10_tax" : 136,
    "payment_method" : "現金",
    "payment_amount" : 2000,
    "deposit_amount" : 2000,
    "change_amount" : 500,
    "note" : "パート・アルバイト募集中！\\nお気軽にお尋ねください。"
}`,
    );
  }
}
